// Copyright 2005 by James Burns, All rights reserved.
// This is an attempt to make a haiku generator. 

five= new Array(
"blustry zen buddhists","barking tiny dogs", "closeted bigot","yowling alley cats","shrugging teenagers","piece of tangled string", "ball of woolen yarn", "big pile of garbage","line of well-wishers", "moldy piece of bread", "middle manager","a terrified rat", "whispering goofballs", "various people", "cross-dressing monkey","terrifying dolt", "sneering idiot","grinning sycophant","hurtful sloganist","annoying haiku","hardened criminal","vile politician", "lost generation", "poetical crap","slimy strategist", "fake conservative", "old-style liberal","evil yuppie scum","proud midwesterner","artful panhandler","noisy spoiled brats","frustrated poseurs","an artful dodger","the thin white kitty","the fat black kitten","untold multitudes","smelly old wino","<em>The Joy of Cooking</em>","this and the other","death in the alley","freakin'<em>New York Times</em>","a pair of rascals","the selfish pundit","group of unwashed nerds","clever little chimp","sneaky bureaucrat"
)

seven= new Array(
"eats dinner amongst the ruins", "falls tumbling down a cliff", "standing ankle deep in blood", "moves silently in the morn'", "embarrassing their parents", "ingesting huge quantities", "avoiding obligations", "hiding in the broad daylight", "cursing like a drunken sailor", "coughing up great gouts of blood", "alternating rhyme structure", "missing the whole point of it", "picking a random catch phrase", "forgetting why they were there", "substituting art for life", "worships at the Christian church", "falling all cattywampus", "waking up from a nightmare", "speaking foreign languages","looks both ways before crossing","mangles the original","looking out for number one","rubbing belly in public","making me queasy just now","licks itself disgustingly", "burps in the face of madness", "looks up in a startled way", "spitting on the ground, wildly","glares with intent and menace","should really know much better","falls apart nevertheless","counts sylables on fingers"
)

nextFive= new Array(
"sadly obstinate", "arguing madly", "surprisingly lithe", "weeping openly", "smells a stinky one", "regretting bad choices", "meaning little else", "killing the others", "ending the poem", "vanishes like smoke", "eating a lunch", "burping openly", "withdraws sneakily", "skips propriety", "committing themselves", "getting all het up", "barely unconscious", "justifying art", "stubbing their big toe", "drives me up a wall", "I can live without", "snoring during sleep", "not very clever", "seems to be confused", "lacking good ethics", "what's the big idea", "skating on thin ice", "strains belief systems","runs out of options","leaves the room screaming","starts over again","waxes poetic","nauseatingly","shambles drunkenly","makes no sense at all","what a wasteful mess","neither here nor there","runs hither and yon","made so redundant","wishing for rewards","stripped of artifice","depressed and morbid","over-reacting","calm at their center","wondering out loud","contemplating life","happy with their choice","violating code","whispering nonsense","clever to the last","good to the last drop")


function pickOne (which){
return which[Math.floor(Math.random()*which.length)];
}


widget.onhide=pauseIt;	// set up hide funtion
widget.onshow=init;	// set up show function

// set up globals

var duration=5000;	// default duration
var tickTok = null;	// this will be timer set in writeIt function
var fade = null;	// this will be timer set in fadeIn function
 
function init(){	// this happens on document load
if (window.widget)
	{
	setup();	// do setup function
	writeIt();	// start main loop
	}
}


function pauseIt(){
clearTimeout(tickTok);	//stop main loop
clearTimeout(fade);	//stop fade loop
}


// This is what actually writes the stuff

function writeIt(){
var outPut= "";
outPut += pickOne(five) + "<br />";
outPut += pickOne(seven) + "<br />";
outPut += pickOne(nextFive) +"<br />";
fillType= document.getElementById("chango");
fillType.innerHTML = outPut;
fadeIn("chango",0);
tickTok= setTimeout("writeIt();", duration);
}

function goJPBd(event)	// send user to my site
{
	if (window.widget)
	{
		widget.openURL("http://jamesburnsdesign.com/");
	}
}


// The following 2 functions are from http://clagnut.com/sandbox/imagefades/

function setOpacity(obj, opacity) {
  opacity = (opacity == 100)?99.999:opacity;
  
  // IE/Win
  obj.style.filter = "alpha(opacity:"+opacity+")";
  
  // Safari<1.2, Konqueror
  obj.style.KHTMLOpacity = opacity/100;
  
  // Older Mozilla and Firefox
  obj.style.MozOpacity = opacity/100;
  
  // Safari 1.2, newer Firefox and Mozilla, CSS3
  obj.style.opacity = opacity/100;
}

function fadeIn(objId,opacity) {
  if (document.getElementById) {
    obj = document.getElementById(objId);
    if (opacity <= 100) {
      setOpacity(obj, opacity);
      opacity += 10;
      fade = setTimeout("fadeIn('"+objId+"',"+opacity+")", 50);
    }
  }
}

// This next section comes largely from the Apple supplied code, which I've adapted
// (but kept their copyright notice)

/*

Copyright _ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.

*/

/***********************************/
// SAVING AND RETRIEVING PREFERENCES
/***********************************/

// setup() is run when the body loads.  It checks to see if there is a preference for this widget
// and if so, applies the preference to the widget.

function setup()
{
	if(window.widget)		// always check to make sure that you are running in Dashboard
		{
		// The preferences are retrieved:
		var timeSet = widget.preferenceForKey("duration");
		if (timeSet && timeSet.length > 0)  // if the retrieved preferences are not empty,
			{								// they are restored.
			duration=timeSet;								
			}
		}
}

// Added by me, to set duration of phrase

function setDuration(time)
{
duration=time;
}


// changeDur() is called whenever a menu item is chosen in the widget's preferences.  It queries the
// menu to find out which option was chosen, applies the change to the widget, and saves the preference.

function changeDur(elem)
{	
	switch( parseInt(elem.options[elem.selectedIndex].value) )					// find out which option was chosen
	{
		case 1: 								
		
			break;
			
			case 2: 								
			
			setDuration(2000);
				if(window.widget)
			{
				widget.setPreferenceForKey(2000,"duration");		// and save the new preference to disk
			}
			break;
			
		case 3:										// if option #3
			setDuration(5000);	
				if(window.widget)
			{
				widget.setPreferenceForKey(5000,"duration");	// and save the new preference to disk
			}
			break;
			
		case 4:										// if option #4
			setDuration(10000);	
				if(window.widget)
			{
				widget.setPreferenceForKey(10000,"duration");	// and save the new preference to disk
			}
			break;
			
	}
} 


/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');				// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}